Imports System.Data.SqlClient

Public Class frmArchive
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents lstYears As System.Windows.Forms.ListBox
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents btnOK As System.Windows.Forms.Button
    Friend WithEvents btnCancel As System.Windows.Forms.Button
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.lstYears = New System.Windows.Forms.ListBox
        Me.Label1 = New System.Windows.Forms.Label
        Me.btnOK = New System.Windows.Forms.Button
        Me.btnCancel = New System.Windows.Forms.Button
        Me.SuspendLayout()
        '
        'lstYears
        '
        Me.lstYears.Location = New System.Drawing.Point(120, 64)
        Me.lstYears.Name = "lstYears"
        Me.lstYears.Size = New System.Drawing.Size(120, 147)
        Me.lstYears.TabIndex = 0
        '
        'Label1
        '
        Me.Label1.Location = New System.Drawing.Point(32, 40)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(216, 16)
        Me.Label1.TabIndex = 1
        Me.Label1.Text = "Archiwizacja wszystkich zamwie z roku:"
        '
        'btnOK
        '
        Me.btnOK.Location = New System.Drawing.Point(288, 40)
        Me.btnOK.Name = "btnOK"
        Me.btnOK.TabIndex = 2
        Me.btnOK.Text = "OK"
        '
        'btnCancel
        '
        Me.btnCancel.Location = New System.Drawing.Point(288, 96)
        Me.btnCancel.Name = "btnCancel"
        Me.btnCancel.TabIndex = 3
        Me.btnCancel.Text = "Anuluj"
        '
        'frmArchive
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(392, 253)
        Me.Controls.Add(Me.btnCancel)
        Me.Controls.Add(Me.btnOK)
        Me.Controls.Add(Me.Label1)
        Me.Controls.Add(Me.lstYears)
        Me.Name = "frmArchive"
        Me.Text = "Archiwizacja zamwie"
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub frmArchive_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        lstYears.Items.Add("1995")
        lstYears.Items.Add("1996")
        lstYears.Items.Add("1997")
        lstYears.Items.Add("1998")
        lstYears.Items.Add("1999")
        lstYears.Items.Add("2000")
        lstYears.Items.Add("2001")
        lstYears.Items.Add("2002")

        ' Warto domylna
        lstYears.SelectedIndex = 0
    End Sub

    Private Sub btnCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCancel.Click
        Me.Hide()
    End Sub

    Private Sub btnOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOK.Click

        Dim sql As String
        Dim result As Integer
        Dim records As Integer
        Dim SelectedYear As String

        ' Tworzenie instancji obiektw Connection i Command
        Dim cnn As SqlConnection = New SqlConnection("server=localhost;uid=sa;database=Nowinki")
        Dim cmd As New SqlCommand

        Dim trans As SqlTransaction

        ' Sprawdzenie roku
        SelectedYear = lstYears.SelectedItem.ToString

        ' Kod jest umieszczony w bloku Try-Catch w celu wychwytywania bdw
        Try

            ' Otwarcie poczenia i rozpoczcie transakcji
            cnn.Open()
            trans = cnn.BeginTransaction

            ' Doczenie polecenia do transakcji
            cmd.Connection = cnn
            cmd.Transaction = trans

            ' Kod SQL, ktry wstawia odpowiednie rekordy do tabeli archiwalnej
            sql = "SELECT * INTO tblZamowienia" & SelectedYear & _
            " FROM tblZamowienia WHERE year (DataZamowienia) = " & SelectedYear

            ' To polecenie rwnie naley do transakcji
            cmd.CommandText = sql

            result = cmd.ExecuteNonQuery()

            ' Wywietlanie wyniku operacji archiwizowania rekordw
            If result > 0 Then
                records = result
                MessageBox.Show("Do tabeli tblZamowienia" & SelectedYear & _
                " pomylnie wstawiono " & records & " rekordw")
            Else
                MessageBox.Show( _
                "Nie wstawiono adnych rekordw do tabeli tblZamowienia" & SelectedYear)
                ' Skoro brak rekordw, nie zachowujemy utworzonej tabeli
                ' Anulowanie (wycofanie) transakcji
                trans.Rollback()
            End If

            If records > 0 Then
                ' Kod SQL, ktry usuwa odpowiednie rekordy z biecej tabeli
                sql = "DELETE FROM tblZamowienia WHERE year(DataZamowienia) = " _
                  & SelectedYear

                ' To polecenie rwnie naley do transakcji
                cmd.CommandText = sql

                result = cmd.ExecuteNonQuery()

                ' Wywietlenie wyniku operacji usuwania rekordw
                If result = records Then
                    MessageBox.Show("Pomylnie usunito " & records & " rekordw")

                    ' Jeli jestemy w tym miejscu, wszystko si udao
                    trans.Commit()
                Else
                    MessageBox.Show("Nie usunito adnych rekordw!")
                End If
            Else
                ' Nie ma nic do zrobienia
            End If

        Catch ex As Exception
            ' Jeli jestemy tutaj, co si nie udao, wic
            ' trzeba anulowa (wycofa) ca transakcj
            Try
                ' Wywietlenie komunikatu o bdzie
                MessageBox.Show(ex.Message & ControlChars.CrLf & ControlChars.CrLf & _
                  "Nieudana transakcja!")

                trans.Rollback()

            Catch ex2 As Exception
            End Try

        Finally
            cnn.Close()
        End Try
    End Sub

End Class
